<?php
/**
 *	WorldWideBoard Homepage
 *	Copyright (C) Robbyn Gerhardt
 *	The forum software was developed for the free use. The free use of the software is guaranteed. 
 *	The software does not stand under the free GNU the change of the code is permitted however. 
 *	The rights for the code are alone with the developer Robbyn Gerhardt.
 *
 *	@package	WorldWideBoard Webspace-Scanner
 *	@author		Robbyn Gerhardt <robbyn@worldwideboard.de>
 *	@copyright	2010 - 2012 by WorldWideBoard and Robbyn Gerhardt
 *	@license	GNU GPLv3 License
 *	@link		http://www.worldwideboard.de
 */
 
 ignore_user_abort(true);
 set_time_limit(0);
 
 define('PFAD',str_replace('\\', '/',dirname(__FILE__))."/");
 
 function phpinfo_array($return=false){

	 ob_start();
	 phpinfo(-1);
	 
	 $pi = preg_replace(
	 array('#^.*<body>(.*)</body>.*$#ms', '#<h2>PHP License</h2>.*$#ms',
	 '#<h1>Configuration</h1>#',  "#\r?\n#", "#</(h1|h2|h3|tr)>#", '# +<#',
	 "#[ \t]+#", '#&nbsp;#', '#  +#', '# class=".*?"#', '%&#039;%',
	  '#<tr>(?:.*?)" src="(?:.*?)=(.*?)" alt="PHP Logo" /></a>'
	  .'<h1>PHP Version (.*?)</h1>(?:\n+?)</td></tr>#',
	  '#<h1><a href="(?:.*?)\?=(.*?)">PHP Credits</a></h1>#',
	  '#<tr>(?:.*?)" src="(?:.*?)=(.*?)"(?:.*?)Zend Engine (.*?),(?:.*?)</tr>#',
	  "# +#", '#<tr>#', '#</tr>#'),
	 array('$1', '', '', '', '</$1>' . "\n", '<', ' ', ' ', ' ', '', ' ',
	  '<h2>PHP Configuration</h2>'."\n".'<tr><td>PHP Version</td><td>$2</td></tr>'.
	  "\n".'<tr><td>PHP Egg</td><td>$1</td></tr>',
	  '<tr><td>PHP Credits Egg</td><td>$1</td></tr>',
	  '<tr><td>Zend Engine</td><td>$2</td></tr>' . "\n" .
	  '<tr><td>Zend Egg</td><td>$1</td></tr>', ' ', '%S%', '%E%'),
	 ob_get_clean());
	
	 $sections = explode('<h2>', strip_tags($pi, '<h2><th><td>'));
	 unset($sections[0]);
	
	 $pi = array();
	 foreach($sections as $section){
	   $n = substr($section, 0, strpos($section, '</h2>'));
	   preg_match_all(
	   '#%S%(?:<td>(.*?)</td>)?(?:<td>(.*?)</td>)?(?:<td>(.*?)</td>)?%E%#',
		 $section, $askapache, PREG_SET_ORDER);
	   foreach($askapache as $m)
		   $pi[$n][$m[1]]=(!isset($m[3])||$m[2]==$m[3])?$m[2]:array_slice($m,2);
	 }
	
	 return ($return === false) ? print_r($pi) : $pi;
	}
	
	$phpinfo = phpinfo_array(true);
 

if($_POST['senden']){
	
	if(function_exists('curl_init')){
		$curl = '
		<div id="curl" onclick="Over(\'curl\')" class="text success">cURL</div>
		<div id="curl_1" style="display:none;" class="text_klein_success stand_success">
			<strong>cURL wurde auf Ihren Server gefunden.</strong><br /><br />
			
			cURL wird in der Forensoftware WorldWideBoard zum Updaten und für das Cloudsystem verwendet. Ohne diese Funktion, kann das Forum nicht automatisch geupdatet werden oder ein Cloudbackup erstellen.
		</div>
		';
	}else{
		$curl = '
		<div id="curl" onclick="Over(\'curl\')" class="text error">cURL</div>
		<div id="curl_1" style="display:none;" class="text_klein_error stand_error">
			<strong>cURL wurde auf Ihren Server nicht gefunden.</strong><br /><br />
			
			cURL wird in der Forensoftware WorldWideBoard zum Updaten und für das Cloudsystem verwendet. Ohne diese Funktion, kann das Forum nicht automatisch geupdatet werden oder ein Cloudbackup erstellen.
		</div>
		';
	}
	
	if(version_compare(phpversion(),'5.0', ">=")){
		$php_version = '
		<div id="php_version" onclick="Over(\'php_version\');" class="text success">PHP-Version</div>
		<div id="php_version_1" style="display:none;" class="text_klein_success stand_success">
			<strong>Ihre PHP-Version ist größer als 5.0</strong><br /><br />
			
			Ihre PHP-Version muss mindestens 5.0 oder größer sein. Wenn Ihre Version kleiner ist, kann es zu Problemen mit bestimmten Funktionen im Forum geben, da diese in einer alten Version nicht mehr funktionieren.
		</div>
		';
	}else{
		$php_version = '
		<div id="php_version" onclick="Over(\'php_version\');" class="text error">PHP-Version</div>
		<div id="php_version_1" style="display:none;" class="text_klein_error stand_error">
			<strong>Ihre PHP-Version ist kleiner als 5.0</strong><br /><br />
			
			Ihre PHP-Version muss mindestens 5.0 oder größer sein. Wenn Ihre Version kleiner ist, kann es zu Problemen mit bestimmten Funktionen im Forum geben, da diese in einer alten Version nicht mehr funktionieren.
		</div>
		';
	}
	
	if(@ini_get('safe_mode') == 0){
		$safe_mode = '
		<div id="safe_mode" onclick="Over(\'safe_mode\');" class="text success">Safe Mode</div>
		<div id="safe_mode_1" style="display:none;" class="text_klein_success stand_success">
			<strong>Ihr Safe-Mode ist ausgeschalten</strong><br /><br />
			
			Wenn der Safe Mode aktiv ist, sind viele Funktionen in PHP eingeschränkt oder funktionieren garnicht. Um dieses Problem zu umgehen und ein fehlerfreies Forum zu betreiben, sollte dieser immer deaktiviert/ausgeschaltet sein.
		</div>
		';
	}else{
		$safe_mode = '
		<div id="safe_mode" onclick="Over(\'safe_mode\');" class="text error">Safe Mode</div>
		<div id="safe_mode_1" style="display:none;" class="text_klein_error stand_error">
			<strong>Ihr Safe-Mode ist eingeschalten</strong><br /><br />
			
			Wenn der Safe Mode aktiv ist, sind viele Funktionen in PHP eingeschränkt oder funktionieren garnicht. Um dieses Problem zu umgehen und ein fehlerfreies Forum zu betreiben, sollte dieser immer deaktiviert/ausgeschaltet sein.
		</div>
		';
	}
	
	if(@ini_get('register_globals') == 0){
		$register_globals = '
		<div id="register_globals" onclick="Over(\'register_globals\');" class="text success">Register Globals</div>
		<div id="register_globals_1" style="display:none;" class="text_klein_success stand_success">
			<strong>Ihre Register Globals sind deaktiviert.</strong><br /><br />
			
			Die Register Globals sind (leider) eine starke Sicherheitslücke was übergebene Variablen angeht. Wenn man eine Variable wie folgt übergibt index.php?seite=2, dann kann man (wenn Register Globals aktiviert ist) mit der Variable $seite auf den Wert 2 zugreifen.
		</div>
		';
	}else{
		$register_globals = '
		<div id="register_globals" onclick="Over(\'register_globals\');" class="text error">Register Globals</div>
		<div id="register_globals_1" style="display:none;" class="text_klein_error stand_error">
			<strong>Ihre Register Globals sind aktiviert.</strong><br /><br />
			
			Die Register Globals sind (leider) eine starke Sicherheitslücke was übergebene Variablen angeht. Wenn man eine Variable wie folgt übergibt index.php?seite=2, dann kann man (wenn Register Globals aktiviert ist) mit der Variable $seite auf den Wert 2 zugreifen.
		</div>
		';
	}
	
	if(@ini_get('magic_quotes_gpc') == 0){
		$magic_quotes = '
		<div id="magic_quotes" onclick="Over(\'magic_quotes\');" class="text success">Magic Quotes GPC</div>
		<div id="magic_quotes_1" style="display:none;" class="text_klein_success stand_success">
			<strong>Die Magic Quotes GPC sind deaktiviert</strong><br /><br />
			
			Magic Quotes GPC setzt vor Anführungszeichen und Hochkommas in Variablen, die von „außen“ in ein Script einfliessen (URL-Parameter, Datenbankfelder, Textdateien etc.), einen Backslash (\). 
		</div>
		';
	}else{
		$magic_quotes = '
		<div id="magic_quotes" onclick="Over(\'magic_quotes\');" class="text error">Magic Quotes GPC</div>
		<div id="magic_quotes_1" style="display:none;" class="text_klein_error stand_error">
			<strong>Die Magic Quotes GPC sind aktiviert</strong><br /><br />
			
			Magic Quotes GPC setzt vor Anführungszeichen und Hochkommas in Variablen, die von „außen“ in ein Script einfliessen (URL-Parameter, Datenbankfelder, Textdateien etc.), einen Backslash (\). 
		</div>
		';
	}
	
	if(function_exists('json_decode')){
		$json = '
		<div onclick="Over(\'json\');" id="json" class="text success">JSON</div>
		<div id="json_1" style="display:none;" class="text_klein_success stand_success">
			<strong>JSON ist aktiviert</strong><br /><br />
			
			JSON verschlüsselt/entschlüsselt Werte in PHP um die Sicherheit Ihrer Daten zu gewährleiste. Falls diese Funktion nicht existieren sollte hat dies kein Einfluss auf die Funktion Ihres Forums. Ausserdem wird JSON auch im Cloudsystem verwendet, um Daten sicher von einem Ort zum anderen zu bringen.
		</div>
		';
	}else{
		$json = '
		<div id="json" onclick="Over(\'json\');" class="text error">JSON</div>
		<div id="json_1" style="display:none;" class="text_klein_error stand_error">
			<strong>JSON ist deaktiviert</strong><br /><br />
			
			JSON verschlüsselt/entschlüsselt Werte in PHP um die Sicherheit Ihrer Daten zu gewährleiste. Falls diese Funktion nicht existieren sollte hat dies kein Einfluss auf die Funktion Ihres Forums. Ausserdem wird JSON auch im Cloudsystem verwendet, um Daten sicher von einem Ort zum anderen zu bringen.
		</div>
		';
	}
	
	if(strpos($phpinfo['apache2handler']['Loaded Modules'],'mod_rewrite') !== false){
		$mod_rewrite = '
		<div id="mod_rewrite" onclick="Over(\'mod_rewrite\');" class="text success">Mod Rewrite</div>
		<div id="mod_rewrite_1" style="display:none;" class="text_klein_success stand_success">
			<strong>Mod Rewrite ist aktiviert</strong><br /><br />
				
			Mod Rewrite übernimmt den Einfluß der URL, Sie wird von Suchmaschinen unfreundlichen Code in Suchmaschinen freundlichen Code umgewandelt und erhöht somit die Chance, eine besseren Platzierung. Ohne Mod Rewrite funktioniert das ganze Forum nicht.
		</div>
		';
	}else{
		$mod_rewrite = '
		<div id="mod_rewrite" onclick="Over(\'mod_rewrite\');" class="text error">Mod Rewrite</div>
		<div id="mod_rewrite_1" style="display:none;" class="text_klein_error stand_error">
			<strong>Mod Rewrite ist deaktiviert</strong><br /><br />
				
			Mod Rewrite übernimmt den Einfluß der URL, Sie wird von Suchmaschinen unfreundlichen Code in Suchmaschinen freundlichen Code umgewandelt und erhöht somit die Chance, eine besseren Platzierung. Ohne Mod Rewrite funktioniert das ganze Forum nicht.
		</div>
		';
	}
	
	if(function_exists('mysql_connect')){
		$mysql = '
		<div id="mysql" onclick="Over(\'mysql\');" class="text success">MySQL</div>
		<div id="mysql_1" style="display:none;" class="text_klein_success stand_success">
			<strong>MySQL ist auf den Server installiert</strong><br /><br />
			
			MySQL stellt eine Datenbankverbindung her, wo alle Daten des Forums gelagert und verwaltet werden. Dem Forum stehen aber noch andere Datenbankverbindungen zur Verfügung
		</div>
		';
	}else{
		$mysql = '
		<div id="mysql" onclick="Over(\'mysql\');" class="text error">MySQL</div>
		<div id="mysql_1" style="display:none;" class="text_klein_error stand_error">
			<strong>MySQL ist auf den Server nicht installiert</strong><br /><br />
			
			MySQL stellt eine Datenbankverbindung her, wo alle Daten des Forums gelagert und verwaltet werden. Dem Forum stehen aber noch andere Datenbankverbindungen zur Verfügung
		</div>
		';
	}
	
	$controll = 1;
	
}elseif($_POST['install']){
	
	$MainServer		=	"http://www.worldwideboard.de/CurrentVersion.php";
	$MainServer2	=	"http://www.worldwideboard.de/GiveZipData.php";
			
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $MainServer);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$DownloadPaket = curl_exec($ch);
	curl_close($ch); 
	
	$WriteInstallZip	=	file_put_contents(PFAD."install.zip",$DownloadPaket);
	
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $MainServer2);
	curl_setopt($ch, CURLOPT_HEADER, 0);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	$PCLZIP = curl_exec($ch);
	curl_close($ch);
	
	$WritePCLZip		=	file_put_contents(PFAD.'pclzip.lib.php',$PCLZIP);
	
	include_once(PFAD.'pclzip.lib.php');

	$zip = new PclZip(PFAD."install.zip");
	
	if(file_exists(PFAD."install.zip")){
		if(is_writable(PFAD)){
			if($zip->extract(PCLZIP_OPT_PATH, PFAD, PCLZIP_OPT_REPLACE_NEWER))
			{
				if(file_exists(PFAD."install.zip")){
					unlink(PFAD."install.zip");
				}
				
				if(file_exists(PFAD."update.php")){
					unlink(PFAD."update.php");
				}
				
				if(file_exists(PFAD."pclzip.lib.php")){
					unlink(PFAD."pclzip.lib.php");
				}
				
				echo copy(PFAD."install/install.php",PFAD."install.php");
				
				header('Location: install.php');
			}else{
				echo "Forum konnte nicht entpackt werden!";
			}
		}else{
			echo "Bitte geben Sie Ihrem Hautpverzeichniss Schreibrechte";
		}
	}else{
		echo "Die Forrensoftware konnte nicht herruntergeladen werden!";
	}
	
}
?>
<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<link rel="stylesheet" href="http://www.worldwideboard.de/css/style.css" />
<title>Webspace-Scanner</title>
<style type="text/css">

body{
	background-color:#EEE;
}

#scanner2, #scann_data{
	width:100%;
	margin:0 auto;
}

#scann_data{
	margin-top:20px;
}

.stand_success{
	width:95%;
	margin:0 auto;
	background-color:#b2dfc3;
	padding:5px;
	-moz-border-radius-bottomleft:5px;
	-moz-border-radius-bottomright:5px;
	-webkit-border-bottom-left-radius:5px;
	-webkit-border-bottom-right-radius:5px;
	border-bottom-left-radius:5px;
	border-bottom-right-radius:5px;
}

.stand_error{
	width:95%;
	margin:0 auto;
	background-color:#dfb2b2;
	padding:5px;
	-moz-border-radius-bottomleft:5px;
	-moz-border-radius-bottomright:5px;
	-webkit-border-bottom-left-radius:5px;
	-webkit-border-bottom-right-radius:5px;
	border-bottom-left-radius:5px;
	border-bottom-right-radius:5px;

}

#logo_w{
	width:100%;
	text-align:center;
}

.text, .text_bold{
	font-family:Verdana, Geneva, sans-serif;
	font-size:14px;
	color:#858584;
	padding:5px;
	text-shadow:0px 1px 0px #e1fcec;
}

.text_klein_success{
	font-family:Verdana, Geneva, sans-serif;
	font-size:12px;
	color:#2f6f46;
}

.text_klein_error{
	font-family:Verdana, Geneva, sans-serif;
	font-size:12px;
	color:#6f2f2f;
}

.text_bold{
	font-weight:bold;
}

#curl, #php_version, #safe_mode, #register_globals, #magic_quotes, #json, #mod_rewrite, #mysql{
	width:95%;
	margin:0 auto;
	margin-top:10px;
}

.success{
	background-color:#b2dfc3;
	color:#51bc77;
	font-weight:bold;
	text-align:center;
	-moz-border-radius:5px;
	-webkit-border-radius:5px;
	border-radius:5px;
	margin-bottom:0px;
	margin-top:0px;
}

.error{
	background-color:#dfb2b2;
	color:#bc5151;
	font-weight:bold;
	text-align:center;
	-moz-border-radius:5px;
	-webkit-border-radius:5px;
	border-radius:5px;
}

.backRound{
	-moz-border-radius-bottomleft:0px;
	-moz-border-radius-bottomright:0px;
	-webkit-border-bottom-left-radius:0px;
	-webkit-border-bottom-right-radius:0px;
	border-bottom-left-radius:0px;
	border-bottom-right-radius:0px;
}

#contentScanner{
	width:50%;
	padding:10px;
	margin:0 auto;
	background-color:#DDD;
	-moz-border-radius:15px;
	-webkit-border-radius:15px;
	border-radius:15px;
}
</style>
<script type="text/javascript" src="http://code.jquery.com/jquery-1.7.1.min.js"></script>
<script type="text/javascript">
function Over(id){
	var DataField = document.getElementById(id+"_1");
	var Content		=	$('#'+id);
	
	if(DataField.style.display == 'none'){
		DataField.style.display = 'block';
		Content.addClass('backRound');
		
	}else{
		DataField.style.display = 'none';
		Content.removeClass('backRound');
	}
}


function setDarkBG()
{
	$('#darkBG').show();
}
</script>

</head>

<body>
	<div id="logo_w">
    	<img src="http://www.worldwideboard.de/img/logo.png" />
	</div>
    <div id="contentScanner">
        <div id="scanner2">
            <h3>Webspace-Scanner</h3>
            <p>Der Webspace-Scanner zeigt Ihnen ob Ihr Server für die Forensoftware WorldWideBoard kompatibel ist. Falls es Module gibt die Ihr Server nicht aktiviert hat, können Sie ihren Server-Provider darum bitten diese zu aktivieren, falls er dies nicht machen sollte, könnten Sie notfalls auch die Anbieter wechseln. Die meißten Funktionen aber, brauchen diese wichtigen Einstellungen nicht und behindern auf keinen Fall die Arbeit mit dem Forum.
            <br />Wichtige Funktionen werden, wenn sie nicht Installiert sind, mit einem roten Ausrufezeichen markiert. Erklärrungen zu jedem einzelnen Modul finden Sie, sobald sie das jeweilige Modul angeklickt haben.</p>
            <form action="" method="post">
            	<table style="width:100%;">
                	<tr>
                    	<td style="text-align:left;"><input onClick="setDarkBG()" type="submit" name="install" class="button" value="Forum installieren" /></td>
                        <td style="text-align:right;"><input type="submit" name="senden" class="button" value="Scannen" /></td>
                    </tr>
                </table>
            </form>
        </div>
        <?php
        if($controll == 1){
        ?>
            <div id="scann_data">
                <h3>Scann-Ergebniss</h3>
                <?php echo $curl; ?>
                <?php echo $php_version; ?>
                <?php echo $safe_mode; ?>
                <?php echo $register_globals; ?>
                <?php echo $magic_quotes; ?>
                <?php echo $json; ?>
                <?php echo $mod_rewrite; ?>
                <?php echo $mysql; ?>
            </div>
        <?php
        }
        ?>
    </div>
    <div style="background-color:#CCCCCC; opacity:0.5; display:none; position:fixed; width:500px; height:100px; top:250px; left:50px; margin-left:-125px; margin-top:-25px;" id="darkBG">
        <div style="background-color:#EEE;">
            <p style="text-align:center;">Bitte warten, das Forum wird herruntergeladen!</p>
        </div>
    </div>
</body>
</html>